//
// domTest.java
//
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;
import java.sql.*;
import oracle.xml.sql.query.OracleXMLQuery;
import java.io.*;

class domTest
{
   public static void main(String[] argv)
   {
      try
      {
// create the connection
        Connection conn  = getConnection("hr","hr");
// Create the query object
        OracleXMLQuery qry = new OracleXMLQuery(conn, "SELECT * FROM employees");
// Get the XML DOM object. The actual type is the Oracle Parser's DOM
// representation. (XMLDocument)
        XMLDocument domDoc = (XMLDocument)qry.getXMLDOM();
// Print the XML output directly from the DOM
        System.out.println("The DOM version is ");
        domDoc.print(System.out);
// If you would rather print it to a string buffer you can do this
        StringWriter s = new StringWriter(10000);
        domDoc.print(new PrintWriter(s));
        System.out.println(" The string version ---> \n"+s.toString());
        qry.close();   // Always close the query
      }
      catch(Exception e)
      {
        System.out.println(e.toString());
      } // end catch
   } // end main

// Get the connection given the user name and password
   private static Connection getConnection(String user, String passwd)
     throws SQLException
   {
      DriverManager.registerDriver(new oracle.jdbc.OracleDriver());
      Connection conn =
          DriverManager.getConnection("jdbc:oracle:oci:@",user,passwd);
      return conn;
   } // end getConnection
} // end domTest
